(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[     51565,       1107]
NotebookOptionsPosition[     50944,       1088]
NotebookOutlinePosition[     51377,       1105]
CellTagsIndexPosition[     51334,       1102]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"AllLabelledGraphs", "[", 
   RowBox[{"n_", ",", "scale_"}], "]"}], ":=", 
  RowBox[{"Module", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"v", ",", "edges"}], "}"}], ",", 
    RowBox[{
     RowBox[{"v", "=", 
      RowBox[{"Range", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"edges", "=", 
      RowBox[{"UndirectedEdge", "@@@", 
       RowBox[{"Subsets", "[", 
        RowBox[{"v", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{
       RowBox[{"Graph", "[", 
        RowBox[{"v", ",", "#", ",", 
         RowBox[{"VertexCoordinates", "->", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{
              RowBox[{"Sin", "[", 
               RowBox[{"2", " ", "i", " ", 
                RowBox[{"Pi", "/", "n"}]}], "]"}], ",", 
              RowBox[{"Cos", "[", 
               RowBox[{"2", " ", "i", " ", 
                RowBox[{"Pi", "/", "n"}]}], "]"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "0", ",", 
              RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ",", 
         RowBox[{"EdgeStyle", "->", 
          RowBox[{"Directive", "[", 
           RowBox[{"Red", ",", "Thick"}], "]"}]}], ",", 
         RowBox[{"VertexLabels", "\[Rule]", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"i", "\[Rule]", 
             RowBox[{"Placed", "[", 
              RowBox[{"i", ",", "Center"}], "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"i", ",", "n"}], "}"}]}], "]"}]}], ",", 
         RowBox[{"VertexLabelStyle", "\[Rule]", 
          RowBox[{"Directive", "[", 
           RowBox[{"White", ",", "Bold", ",", "8"}], "]"}]}], ",", 
         RowBox[{"VertexStyle", "\[Rule]", "Black"}], ",", 
         RowBox[{"VertexSize", "\[Rule]", ".35"}], ",", 
         RowBox[{"ImageSize", "->", 
          RowBox[{"10", "scale"}]}]}], "]"}], "&"}], "/@", 
      RowBox[{"Subsets", "[", "edges", "]"}]}]}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{
   RowBox[{"UnlabelledSimpleGraphs", "[", 
    RowBox[{
     RowBox[{"n_Integer", "?", "NonNegative"}], ",", "scale_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"v", ",", "edges"}], "}"}], ",", 
     RowBox[{
      RowBox[{"v", "=", 
       RowBox[{"Range", "[", "n", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"edges", "=", 
       RowBox[{"UndirectedEdge", "@@@", 
        RowBox[{"Subsets", "[", 
         RowBox[{"v", ",", 
          RowBox[{"{", "2", "}"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Join", "@@", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"DeleteDuplicatesBy", "[", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"Graph", "[", 
              RowBox[{"v", ",", "#", ",", 
               RowBox[{"VertexCoordinates", "->", 
                RowBox[{"Table", "[", 
                 RowBox[{
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"Sin", "[", 
                    RowBox[{"2", " ", "i", " ", 
                    RowBox[{"Pi", "/", "n"}]}], "]"}], ",", 
                    RowBox[{"Cos", "[", 
                    RowBox[{"2", " ", "i", " ", 
                    RowBox[{"Pi", "/", "n"}]}], "]"}]}], "}"}], ",", 
                  RowBox[{"{", 
                   RowBox[{"i", ",", "0", ",", 
                    RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ",", 
               RowBox[{"EdgeStyle", "->", 
                RowBox[{"Directive", "[", 
                 RowBox[{"Red", ",", "Thick"}], "]"}]}], ",", 
               RowBox[{"VertexLabels", "\[Rule]", "None"}], ",", 
               RowBox[{"VertexLabelStyle", "\[Rule]", 
                RowBox[{"Directive", "[", 
                 RowBox[{"White", ",", "Bold", ",", "8"}], "]"}]}], ",", 
               RowBox[{"VertexStyle", "\[Rule]", "Black"}], ",", 
               RowBox[{"VertexSize", "\[Rule]", ".35"}], ",", 
               RowBox[{"ImageSize", "->", 
                RowBox[{"10", "scale"}]}]}], "]"}], "&"}], "/@", 
            RowBox[{"Subsets", "[", 
             RowBox[{"edges", ",", 
              RowBox[{"{", "m", "}"}]}], "]"}]}], ",", "CanonicalGraph"}], 
          "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"m", ",", "0", ",", 
           RowBox[{"Binomial", "[", 
            RowBox[{"n", ",", "2"}], "]"}]}], "}"}]}], "]"}]}]}]}], "]"}]}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Manipulate", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"grs", "=", 
      RowBox[{"AllLabelledGraphs", "[", 
       RowBox[{"n", ",", "scale"}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"fams", "=", 
      RowBox[{"GatherBy", "[", 
       RowBox[{"grs", ",", 
        RowBox[{"#", "//", 
         RowBox[{"EdgeCount", "&"}]}]}], "]"}]}], ";", "\[IndentingNewLine]", 
     RowBox[{"image", "=", 
      RowBox[{"Column", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"StringJoin", "[", 
           RowBox[{"\"\<Molecular constitution \>\"", ",", 
            RowBox[{"ToString", "[", "n", "]"}], 
            ",", "\"\<-atom Class\\nGraph isomorphisms (Genera):\>\""}], 
           "]"}], ",", 
          RowBox[{"UnlabelledSimpleGraphs", "[", 
           RowBox[{"n", ",", "scale"}], "]"}], ",", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{"genera", "=", 
            RowBox[{"Table", "[", 
             RowBox[{
              RowBox[{"GatherBy", "[", 
               RowBox[{
                RowBox[{"fams", "[", 
                 RowBox[{"[", "i", "]"}], "]"}], ",", 
                RowBox[{
                 RowBox[{"CanonicalGraph", "[", "#", "]"}], "&"}]}], "]"}], ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", 
                RowBox[{"Length", "[", "fams", "]"}]}], "}"}]}], "]"}]}], ";",
            "\[IndentingNewLine]", "\"\<\\nSpecies counts:\>\""}], ",", 
          "\[IndentingNewLine]", 
          RowBox[{"Map", "[", 
           RowBox[{"Length", ",", "genera", ",", 
            RowBox[{"{", "2", "}"}]}], "]"}], ",", 
          "\[IndentingNewLine]", "\"\<\\nTaxonomically grouped species:\>\"", 
          ",", "\n", 
          RowBox[{"TableForm", "[", "\[IndentingNewLine]", 
           RowBox[{
            RowBox[{
             RowBox[{"th", "=", 
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{"Row", "[", 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{"Subscript", "[", 
                    RowBox[{"F", ",", "i"}], "]"}], ",", 
                   RowBox[{"Subscript", "[", 
                    RowBox[{"G", ",", "j"}], "]"}]}], "}"}], "]"}], ",", 
                RowBox[{"{", 
                 RowBox[{"i", ",", 
                  RowBox[{"Length", "[", "genera", "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"j", ",", 
                  RowBox[{"Length", "[", 
                   RowBox[{"genera", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}],
              ";", "\[IndentingNewLine]", 
             RowBox[{"Table", "[", 
              RowBox[{
               RowBox[{"TableForm", "[", 
                RowBox[{
                 RowBox[{"Table", "[", 
                  RowBox[{
                   RowBox[{"TableForm", "[", 
                    RowBox[{
                    RowBox[{"Partition", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{"bool", ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Column", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"genera", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], ",", 
                    RowBox[{"MatrixForm", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"genera", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j", ",", "k"}], "]"}], "]"}], "//", 
                    "AdjacencyMatrix"}], ",", 
                    RowBox[{"TableSpacing", "\[Rule]", 
                    RowBox[{"{", 
                    RowBox[{".6", ",", ".6"}], "}"}]}]}], "]"}]}], "}"}], ",", 
                    RowBox[{"Alignment", "->", "Center"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"k", ",", "1", ",", 
                    RowBox[{"Length", "[", 
                    RowBox[{"genera", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j"}], "]"}], "]"}], "]"}]}], "}"}]}], 
                    "]"}], ",", 
                    RowBox[{"genera", "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "j"}], "]"}], "]"}]}], "]"}], ",", 
                    "cols", ",", "cols", ",", "1", ",", 
                    RowBox[{"{", "}"}]}], "]"}], ",", 
                    RowBox[{"TableSpacing", "->", 
                    RowBox[{"{", 
                    RowBox[{".8", ",", ".8"}], "}"}]}]}], "]"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"j", ",", 
                    RowBox[{"Length", "[", 
                    RowBox[{"genera", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], ",", 
                 RowBox[{"TableHeadings", "->", 
                  RowBox[{"{", 
                   RowBox[{
                    RowBox[{"th", "[", 
                    RowBox[{"[", "i", "]"}], "]"}], ",", "None"}], "}"}]}], ",", 
                 RowBox[{"TableSpacing", "\[Rule]", 
                  RowBox[{"{", 
                   RowBox[{"3", ",", "1"}], "}"}]}]}], "]"}], ",", 
               RowBox[{"{", 
                RowBox[{"i", ",", 
                 RowBox[{"Length", "[", "genera", "]"}]}], "}"}]}], "]"}]}], ",", 
            RowBox[{"TableSpacing", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"4", ",", "1"}], "}"}]}]}], "]"}]}], "}"}], 
        "\[IndentingNewLine]", ",", 
        RowBox[{"Frame", "->", "True"}], ",", 
        RowBox[{"FrameStyle", "->", 
         RowBox[{"Directive", "[", 
          RowBox[{"White", ",", "Thick"}], "]"}]}]}], "]"}]}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "n", ",", "3", 
        ",", "\"\<\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)\>\""}], "}"}],
       ",", 
      RowBox[{"{", 
       RowBox[{"1", ",", "2", ",", "3", ",", "4", ",", "5"}], "}"}]}], "}"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"scale", ",", "3.5"}], "}"}], ",", "1", ",", "6", ",", 
      RowBox[{"Appearance", "->", "\"\<Open\>\""}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"cols", ",", "12", ",", "\"\<columns across\>\""}], "}"}], ",",
       "6", ",", "50", ",", "1", ",", 
      RowBox[{"Appearance", "->", "\"\<Open\>\""}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
       "bool", ",", "False", 
        ",", "\"\<show adjacency\\n        matricies\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"True", ",", "False"}], "}"}]}], "}"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"SynchronousUpdating", "\[Rule]", "False"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.9658844704799976`*^9, 3.9658845197166653`*^9}, {
   3.9658845615897827`*^9, 3.965884566039694*^9}, {3.965884663984535*^9, 
   3.965884665261902*^9}, {3.9658847840275536`*^9, 3.9658848999888115`*^9}, {
   3.965885068847805*^9, 3.9658850885480022`*^9}, {3.965885476353731*^9, 
   3.965885518756922*^9}, {3.9658855738100567`*^9, 3.965885587179821*^9}, {
   3.965885617522003*^9, 3.9658856340739975`*^9}, {3.9658856760867805`*^9, 
   3.9658857110817356`*^9}, {3.965891502060566*^9, 3.965891524124008*^9}, {
   3.9658916313577003`*^9, 3.9658917707589436`*^9}, {3.965937815218876*^9, 
   3.965937815409937*^9}, {3.9659461786599236`*^9, 3.965946183128111*^9}, {
   3.9659462143279266`*^9, 3.965946256122843*^9}, 3.9659582447927666`*^9, {
   3.9659583901445656`*^9, 3.9659584145856247`*^9}, {3.965958522942457*^9, 
   3.965958530382866*^9}, {3.965958567646244*^9, 3.9659585722919807`*^9}, {
   3.9659586108025246`*^9, 3.9659586969645176`*^9}, {3.965959409370489*^9, 
   3.9659594605031033`*^9}, 3.965961670144579*^9, {3.9659617689979744`*^9, 
   3.9659617725031185`*^9}, {3.965964199776188*^9, 3.9659642260132847`*^9}, {
   3.966006167017441*^9, 3.966006178924469*^9}, {3.9660062326857395`*^9, 
   3.966006246281765*^9}, {3.9660063017027683`*^9, 3.9660063146216984`*^9}, {
   3.9660063987380447`*^9, 3.9660065157870197`*^9}, {3.966006771999647*^9, 
   3.9660067834152527`*^9}, {3.9660068210822105`*^9, 3.966006821585802*^9}, {
   3.9660068896881886`*^9, 3.966006947948021*^9}, {3.966006981942707*^9, 
   3.96600699797369*^9}, 3.9660070483565617`*^9, {3.9660071063783703`*^9, 
   3.966007107898653*^9}, {3.9660074085951176`*^9, 3.96600741113291*^9}, {
   3.966007529768837*^9, 3.9660075386199837`*^9}, {3.966007698729452*^9, 
   3.966007739237034*^9}, {3.9660079502024803`*^9, 3.966007950640806*^9}, {
   3.966008192756405*^9, 3.966008212463833*^9}, {3.9660092834294033`*^9, 
   3.966009286796612*^9}, {3.966009502007616*^9, 3.966009550373993*^9}, {
   3.9660096269061527`*^9, 3.9660096440376225`*^9}, {3.9660096974032974`*^9, 
   3.9660097265168476`*^9}, {3.9660097675531673`*^9, 3.966009789520275*^9}, 
   3.9660098782704716`*^9, 3.9660103643601456`*^9, 3.96602006603405*^9, {
   3.966020117049244*^9, 3.9660201474874516`*^9}, {3.9660201928489704`*^9, 
   3.966020230508219*^9}, {3.966020278876301*^9, 3.966020439229334*^9}, {
   3.9660205158091545`*^9, 3.966020533825552*^9}, {3.966022108646551*^9, 
   3.96602214309276*^9}, 3.96605051002425*^9, {3.9660506180948906`*^9, 
   3.966050618295952*^9}, {3.9660507199144573`*^9, 3.9660507202780457`*^9}, {
   3.966050797562069*^9, 3.966050797678093*^9}, {3.9661000885841236`*^9, 
   3.966100113619713*^9}, {3.966100262219614*^9, 3.966100425915743*^9}, {
   3.9661004777687817`*^9, 3.9661004788375053`*^9}, {3.966100642726534*^9, 
   3.966100702559971*^9}, {3.9661008710000553`*^9, 3.966100893189907*^9}, {
   3.9661009494781265`*^9, 3.966100950960367*^9}, {3.966100997649933*^9, 
   3.966101005034521*^9}, {3.9661010525008163`*^9, 3.9661010799738636`*^9}, {
   3.9661011389923115`*^9, 3.9661011501475925`*^9}, {3.9661029907197304`*^9, 
   3.966103058904831*^9}, {3.9661030934493637`*^9, 3.9661031782467537`*^9}, {
   3.966103230623657*^9, 3.966103328506157*^9}, {3.9661033660866203`*^9, 
   3.9661034461263676`*^9}, {3.9661035570887833`*^9, 
   3.9661035621181087`*^9}, {3.966103596483368*^9, 3.966103663192587*^9}, 
   3.9661037556856346`*^9, {3.9661061288640842`*^9, 3.9661061312189045`*^9}, {
   3.9661249489284344`*^9, 3.9661249498224792`*^9}, {3.9661252879295387`*^9, 
   3.966125291168413*^9}, {3.966125407830822*^9, 3.966125412057659*^9}, {
   3.9661254435808105`*^9, 3.966125445891205*^9}, 3.9661255194360104`*^9, {
   3.9661255543850803`*^9, 3.966125592763918*^9}, {3.9661257056078854`*^9, 
   3.9661257626686935`*^9}, {3.96612677465353*^9, 3.96612696531229*^9}, {
   3.9661271298203793`*^9, 3.966127140917719*^9}, {3.966206874826601*^9, 
   3.966206881605139*^9}, 3.9662069370045815`*^9, {3.9662070695948677`*^9, 
   3.966207070225956*^9}, {3.966210172452997*^9, 3.9662102316701355`*^9}, {
   3.966210353150856*^9, 3.9662103541101437`*^9}, {3.966210392369837*^9, 
   3.9662104322250633`*^9}, {3.9662112106527767`*^9, 
   3.9662112174305305`*^9}, {3.9662113332297*^9, 3.96621136183284*^9}, {
   3.96621144999687*^9, 3.9662114829923897`*^9}, {3.9662116022274265`*^9, 
   3.9662116405222607`*^9}, {3.96621169750161*^9, 3.9662117904969673`*^9}, {
   3.966212396239748*^9, 3.9662123963513927`*^9}, {3.9662124314164944`*^9, 
   3.9662124350007*^9}, {3.966212629744133*^9, 3.9662127037679443`*^9}, {
   3.966465309727373*^9, 3.9664653104344788`*^9}, {3.970678321501274*^9, 
   3.9706783278965282`*^9}, {3.970678400383932*^9, 3.970678468859234*^9}, {
   3.970678511153076*^9, 3.9706785929735928`*^9}, 3.9706796118870945`*^9, {
   3.970679816299309*^9, 3.970679840460785*^9}, {3.9706799195976906`*^9, 
   3.97067994328928*^9}, {3.9707004740554504`*^9, 3.970700475369816*^9}, {
   3.9707007975442104`*^9, 3.9707007993118153`*^9}, {3.9707009047856216`*^9, 
   3.970700948393135*^9}, {3.9707012505957203`*^9, 3.9707012531885223`*^9}, {
   3.9707012848904057`*^9, 3.9707013357982616`*^9}, {3.970701966707718*^9, 
   3.970701986194681*^9}, {3.9707020260886936`*^9, 3.970702121931469*^9}, {
   3.970702174309389*^9, 3.970702181049494*^9}, {3.9707065179126167`*^9, 
   3.9707065193055973`*^9}},
 CellLabel->"In[59]:=",ExpressionUUID->"8c4e20b7-8d83-794e-9530-d915d80c55fb"],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`bool$$ = False, $CellContext`cols$$ = 
    12, $CellContext`n$$ = 3, $CellContext`scale$$ = 3.5, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`n$$], 3, 
       "\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)"}, {1, 2, 3, 4, 5}, 
      ControlType -> SetterBar}, {{
       Hold[$CellContext`scale$$], 3.5}, 1, 6, ControlType -> Manipulator}, {{
       Hold[$CellContext`cols$$], 12, "columns across"}, 6, 50, 1, 
      ControlType -> Manipulator}, {{
       Hold[$CellContext`bool$$], False, 
       "show adjacency\n        matricies"}, {True, False}, ControlType -> 
      Checkbox}}, Typeset`size$$ = {
    195.01120605468748`, {136.8441295783428, 141.1430797736553}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = False, 
    Typeset`keyframeActionsQ$$ = False, Typeset`keyframeList$$ = {}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`bool$$ = False, $CellContext`cols$$ = 
        12, $CellContext`n$$ = 3, $CellContext`scale$$ = 3.5}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$, Typeset`keyframeActionsQ$$, 
        Typeset`keyframeList$$}, 
      "Body" :> ($CellContext`grs = \
$CellContext`AllLabelledGraphs[$CellContext`n$$, $CellContext`scale$$]; \
$CellContext`fams = GatherBy[$CellContext`grs, 
          (EdgeCount& )[#]]; $CellContext`image = 
        Column[{"Molecular constitution " <> ToString[$CellContext`n$$] <> 
           "-atom Class\nGraph isomorphisms (Genera):", 
           $CellContext`UnlabelledSimpleGraphs[$CellContext`n$$, \
$CellContext`scale$$], $CellContext`genera = Table[
              GatherBy[
               Part[$CellContext`fams, $CellContext`i], 
               CanonicalGraph[#]& ], {$CellContext`i, 
               Length[$CellContext`fams]}]; "\nSpecies counts:", 
           Map[Length, $CellContext`genera, {2}], 
           "\nTaxonomically grouped species:", 
           TableForm[$CellContext`th = Table[
               Row[{
                 Subscript[$CellContext`F, $CellContext`i], 
                 Subscript[$CellContext`G, $CellContext`j]}], {$CellContext`i, 
                Length[$CellContext`genera]}, {$CellContext`j, 
                Length[
                 Part[$CellContext`genera, $CellContext`i]]}]; Table[
              TableForm[
               Table[
                TableForm[
                 Partition[
                  If[$CellContext`bool$$, 
                   Table[
                    Column[{
                    
                    Part[$CellContext`genera, $CellContext`i, $CellContext`j, \
$CellContext`k], 
                    MatrixForm[
                    AdjacencyMatrix[
                    
                    Part[$CellContext`genera, $CellContext`i, $CellContext`j, \
$CellContext`k]], TableSpacing -> {0.6, 0.6}]}, Alignment -> 
                    Center], {$CellContext`k, 1, 
                    Length[
                    
                    Part[$CellContext`genera, $CellContext`i, \
$CellContext`j]]}], 
                   
                   Part[$CellContext`genera, $CellContext`i, \
$CellContext`j]], $CellContext`cols$$, $CellContext`cols$$, 1, {}], 
                 TableSpacing -> {0.8, 0.8}], {$CellContext`j, 
                 Length[
                  Part[$CellContext`genera, $CellContext`i]]}], TableHeadings -> {
                 Part[$CellContext`th, $CellContext`i], None}, 
               TableSpacing -> {3, 1}], {$CellContext`i, 
               Length[$CellContext`genera]}], TableSpacing -> {4, 1}]}, Frame -> 
          True, FrameStyle -> Directive[White, Thick]]), 
      "Specifications" :> {{{$CellContext`n$$, 3, 
          "\!\(\*StyleBox[\"n\",FontSlant->\"Italic\"]\)"}, {1, 2, 3, 4, 
         5}}, {{$CellContext`scale$$, 3.5}, 1, 6, Appearance -> 
         "Open"}, {{$CellContext`cols$$, 12, "columns across"}, 6, 50, 1, 
         Appearance -> 
         "Open"}, {{$CellContext`bool$$, False, 
          "show adjacency\n        matricies"}, {True, False}}}, 
      "Options" :> {SynchronousUpdating -> False}, "DefaultOptions" :> {}],
     ImageSizeCache->{
      227.33620605468747`, {222.65204705881155`, 226.95099725412405`}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`grs = {
         Graph[{1, 2, 3}, {}, {EdgeStyle -> {
             Directive[
              RGBColor[1, 0, 0], 
              Thickness[Large]]}, ImageSize -> 35., 
           VertexCoordinates -> {{0, 1}, {
             Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
           VertexLabels -> {
            2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
             Placed[3, Center]}, VertexLabelStyle -> {
             Directive[
              GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
             GrayLevel[0]}}], 
         Graph[{1, 2, 3}, {
           UndirectedEdge[1, 2]}, {EdgeStyle -> {
             Directive[
              RGBColor[1, 0, 0], 
              Thickness[Large]]}, ImageSize -> 35., 
           VertexCoordinates -> {{0, 1}, {
             Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
           VertexLabels -> {
            2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
             Placed[3, Center]}, VertexLabelStyle -> {
             Directive[
              GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
             GrayLevel[0]}}], 
         Graph[{1, 2, 3}, {
           UndirectedEdge[1, 3]}, {EdgeStyle -> {
             Directive[
              RGBColor[1, 0, 0], 
              Thickness[Large]]}, ImageSize -> 35., 
           VertexCoordinates -> {{0, 1}, {
             Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
           VertexLabels -> {
            2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
             Placed[3, Center]}, VertexLabelStyle -> {
             Directive[
              GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
             GrayLevel[0]}}], 
         Graph[{1, 2, 3}, {
           UndirectedEdge[2, 3]}, {EdgeStyle -> {
             Directive[
              RGBColor[1, 0, 0], 
              Thickness[Large]]}, ImageSize -> 35., 
           VertexCoordinates -> {{0, 1}, {
             Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
           VertexLabels -> {
            2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
             Placed[3, Center]}, VertexLabelStyle -> {
             Directive[
              GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
             GrayLevel[0]}}], 
         Graph[{1, 2, 3}, {
           UndirectedEdge[1, 2], 
           UndirectedEdge[1, 3]}, {EdgeStyle -> {
             Directive[
              RGBColor[1, 0, 0], 
              Thickness[Large]]}, ImageSize -> 35., 
           VertexCoordinates -> {{0, 1}, {
             Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
           VertexLabels -> {
            2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
             Placed[3, Center]}, VertexLabelStyle -> {
             Directive[
              GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
             GrayLevel[0]}}], 
         Graph[{1, 2, 3}, {
           UndirectedEdge[1, 2], 
           UndirectedEdge[2, 3]}, {EdgeStyle -> {
             Directive[
              RGBColor[1, 0, 0], 
              Thickness[Large]]}, ImageSize -> 35., 
           VertexCoordinates -> {{0, 1}, {
             Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
           VertexLabels -> {
            2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
             Placed[3, Center]}, VertexLabelStyle -> {
             Directive[
              GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
             GrayLevel[0]}}], 
         Graph[{1, 2, 3}, {
           UndirectedEdge[1, 3], 
           UndirectedEdge[2, 3]}, {EdgeStyle -> {
             Directive[
              RGBColor[1, 0, 0], 
              Thickness[Large]]}, ImageSize -> 35., 
           VertexCoordinates -> {{0, 1}, {
             Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
           VertexLabels -> {
            2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
             Placed[3, Center]}, VertexLabelStyle -> {
             Directive[
              GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
             GrayLevel[0]}}], 
         Graph[{1, 2, 3}, {
           UndirectedEdge[1, 2], 
           UndirectedEdge[1, 3], 
           UndirectedEdge[2, 3]}, {EdgeStyle -> {
             Directive[
              RGBColor[1, 0, 0], 
              Thickness[Large]]}, ImageSize -> 35., 
           VertexCoordinates -> {{0, 1}, {
             Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
           VertexLabels -> {
            2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
             Placed[3, Center]}, VertexLabelStyle -> {
             Directive[
              GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
             GrayLevel[0]}}]}, $CellContext`AllLabelledGraphs[
         Pattern[$CellContext`n, 
          Blank[]], 
         Pattern[$CellContext`scale, 
          Blank[]]] := 
       Module[{$CellContext`v, $CellContext`edges}, $CellContext`v = 
          Range[$CellContext`n]; $CellContext`edges = MapApply[UndirectedEdge, 
            Subsets[$CellContext`v, {2}]]; 
         Map[Graph[$CellContext`v, #, VertexCoordinates -> Table[{
               Sin[2 $CellContext`i (Pi/$CellContext`n)], 
               Cos[2 $CellContext`i (Pi/$CellContext`n)]}, {$CellContext`i, 
               0, $CellContext`n - 1}], EdgeStyle -> Directive[Red, Thick], 
            VertexLabels -> 
            Table[$CellContext`i -> 
              Placed[$CellContext`i, 
                Center], {$CellContext`i, $CellContext`n}], VertexLabelStyle -> 
            Directive[White, Bold, 8], VertexStyle -> Black, VertexSize -> 
            0.35, ImageSize -> 10 $CellContext`scale]& , 
           Subsets[$CellContext`edges]]], $CellContext`fams = {{
          Graph[{1, 2, 3}, {}, {EdgeStyle -> {
              Directive[
               RGBColor[1, 0, 0], 
               Thickness[Large]]}, ImageSize -> 35., 
            VertexCoordinates -> {{0, 1}, {
              Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
            VertexLabels -> {
             2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
              Placed[3, Center]}, VertexLabelStyle -> {
              Directive[
               GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
              GrayLevel[0]}}]}, {
          Graph[{1, 2, 3}, {
            UndirectedEdge[1, 2]}, {EdgeStyle -> {
              Directive[
               RGBColor[1, 0, 0], 
               Thickness[Large]]}, ImageSize -> 35., 
            VertexCoordinates -> {{0, 1}, {
              Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
            VertexLabels -> {
             2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
              Placed[3, Center]}, VertexLabelStyle -> {
              Directive[
               GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
              GrayLevel[0]}}], 
          Graph[{1, 2, 3}, {
            UndirectedEdge[1, 3]}, {EdgeStyle -> {
              Directive[
               RGBColor[1, 0, 0], 
               Thickness[Large]]}, ImageSize -> 35., 
            VertexCoordinates -> {{0, 1}, {
              Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
            VertexLabels -> {
             2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
              Placed[3, Center]}, VertexLabelStyle -> {
              Directive[
               GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
              GrayLevel[0]}}], 
          Graph[{1, 2, 3}, {
            UndirectedEdge[2, 3]}, {EdgeStyle -> {
              Directive[
               RGBColor[1, 0, 0], 
               Thickness[Large]]}, ImageSize -> 35., 
            VertexCoordinates -> {{0, 1}, {
              Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
            VertexLabels -> {
             2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
              Placed[3, Center]}, VertexLabelStyle -> {
              Directive[
               GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
              GrayLevel[0]}}]}, {
          Graph[{1, 2, 3}, {
            UndirectedEdge[1, 2], 
            UndirectedEdge[1, 3]}, {EdgeStyle -> {
              Directive[
               RGBColor[1, 0, 0], 
               Thickness[Large]]}, ImageSize -> 35., 
            VertexCoordinates -> {{0, 1}, {
              Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
            VertexLabels -> {
             2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
              Placed[3, Center]}, VertexLabelStyle -> {
              Directive[
               GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
              GrayLevel[0]}}], 
          Graph[{1, 2, 3}, {
            UndirectedEdge[1, 2], 
            UndirectedEdge[2, 3]}, {EdgeStyle -> {
              Directive[
               RGBColor[1, 0, 0], 
               Thickness[Large]]}, ImageSize -> 35., 
            VertexCoordinates -> {{0, 1}, {
              Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
            VertexLabels -> {
             2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
              Placed[3, Center]}, VertexLabelStyle -> {
              Directive[
               GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
              GrayLevel[0]}}], 
          Graph[{1, 2, 3}, {
            UndirectedEdge[1, 3], 
            UndirectedEdge[2, 3]}, {EdgeStyle -> {
              Directive[
               RGBColor[1, 0, 0], 
               Thickness[Large]]}, ImageSize -> 35., 
            VertexCoordinates -> {{0, 1}, {
              Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
            VertexLabels -> {
             2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
              Placed[3, Center]}, VertexLabelStyle -> {
              Directive[
               GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
              GrayLevel[0]}}]}, {
          Graph[{1, 2, 3}, {
            UndirectedEdge[1, 2], 
            UndirectedEdge[1, 3], 
            UndirectedEdge[2, 3]}, {EdgeStyle -> {
              Directive[
               RGBColor[1, 0, 0], 
               Thickness[Large]]}, ImageSize -> 35., 
            VertexCoordinates -> {{0, 1}, {
              Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
            VertexLabels -> {
             2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
              Placed[3, Center]}, VertexLabelStyle -> {
              Directive[
               GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
              GrayLevel[0]}}]}}, $CellContext`image = 
       Column[{"Molecular constitution 3-atom Class\nGraph isomorphisms \
(Genera):", {
           Graph[{1, 2, 3}, {}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {None}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}], 
           Graph[{1, 2, 3}, {
             UndirectedEdge[1, 2]}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {None}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}], 
           Graph[{1, 2, 3}, {
             UndirectedEdge[1, 2], 
             UndirectedEdge[1, 3]}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {None}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}], 
           Graph[{1, 2, 3}, {
             UndirectedEdge[1, 2], 
             UndirectedEdge[1, 3], 
             UndirectedEdge[2, 3]}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {None}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}]}, "\nSpecies counts:", {{1}, {3}, {3}, {1}}, 
          "\nTaxonomically grouped species:", 
          TableForm[{
            TableForm[{
              TableForm[{{
                 Graph[{1, 2, 3}, {}, {EdgeStyle -> {
                    Directive[
                    RGBColor[1, 0, 0], 
                    Thickness[Large]]}, ImageSize -> 35., 
                   VertexCoordinates -> {{0, 1}, {
                    Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
                   VertexLabels -> {
                    2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
                    Placed[3, Center]}, VertexLabelStyle -> {
                    Directive[
                    GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, 
                   VertexStyle -> {
                    GrayLevel[0]}}]}}, TableSpacing -> {0.8, 0.8}]}, 
             TableHeadings -> {{
                Row[{
                  Subscript[$CellContext`F, 1], 
                  Subscript[$CellContext`G, 1]}]}, None}, 
             TableSpacing -> {3, 1}], 
            TableForm[{
              TableForm[{{
                 Graph[{1, 2, 3}, {
                   UndirectedEdge[1, 2]}, {EdgeStyle -> {
                    Directive[
                    RGBColor[1, 0, 0], 
                    Thickness[Large]]}, ImageSize -> 35., 
                   VertexCoordinates -> {{0, 1}, {
                    Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
                   VertexLabels -> {
                    2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
                    Placed[3, Center]}, VertexLabelStyle -> {
                    Directive[
                    GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, 
                   VertexStyle -> {
                    GrayLevel[0]}}], 
                 Graph[{1, 2, 3}, {
                   UndirectedEdge[1, 3]}, {EdgeStyle -> {
                    Directive[
                    RGBColor[1, 0, 0], 
                    Thickness[Large]]}, ImageSize -> 35., 
                   VertexCoordinates -> {{0, 1}, {
                    Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
                   VertexLabels -> {
                    2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
                    Placed[3, Center]}, VertexLabelStyle -> {
                    Directive[
                    GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, 
                   VertexStyle -> {
                    GrayLevel[0]}}], 
                 Graph[{1, 2, 3}, {
                   UndirectedEdge[2, 3]}, {EdgeStyle -> {
                    Directive[
                    RGBColor[1, 0, 0], 
                    Thickness[Large]]}, ImageSize -> 35., 
                   VertexCoordinates -> {{0, 1}, {
                    Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
                   VertexLabels -> {
                    2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
                    Placed[3, Center]}, VertexLabelStyle -> {
                    Directive[
                    GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, 
                   VertexStyle -> {
                    GrayLevel[0]}}]}}, TableSpacing -> {0.8, 0.8}]}, 
             TableHeadings -> {{
                Row[{
                  Subscript[$CellContext`F, 2], 
                  Subscript[$CellContext`G, 1]}]}, None}, 
             TableSpacing -> {3, 1}], 
            TableForm[{
              TableForm[{{
                 Graph[{1, 2, 3}, {
                   UndirectedEdge[1, 2], 
                   UndirectedEdge[1, 3]}, {EdgeStyle -> {
                    Directive[
                    RGBColor[1, 0, 0], 
                    Thickness[Large]]}, ImageSize -> 35., 
                   VertexCoordinates -> {{0, 1}, {
                    Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
                   VertexLabels -> {
                    2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
                    Placed[3, Center]}, VertexLabelStyle -> {
                    Directive[
                    GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, 
                   VertexStyle -> {
                    GrayLevel[0]}}], 
                 Graph[{1, 2, 3}, {
                   UndirectedEdge[1, 2], 
                   UndirectedEdge[2, 3]}, {EdgeStyle -> {
                    Directive[
                    RGBColor[1, 0, 0], 
                    Thickness[Large]]}, ImageSize -> 35., 
                   VertexCoordinates -> {{0, 1}, {
                    Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
                   VertexLabels -> {
                    2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
                    Placed[3, Center]}, VertexLabelStyle -> {
                    Directive[
                    GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, 
                   VertexStyle -> {
                    GrayLevel[0]}}], 
                 Graph[{1, 2, 3}, {
                   UndirectedEdge[1, 3], 
                   UndirectedEdge[2, 3]}, {EdgeStyle -> {
                    Directive[
                    RGBColor[1, 0, 0], 
                    Thickness[Large]]}, ImageSize -> 35., 
                   VertexCoordinates -> {{0, 1}, {
                    Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
                   VertexLabels -> {
                    2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
                    Placed[3, Center]}, VertexLabelStyle -> {
                    Directive[
                    GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, 
                   VertexStyle -> {
                    GrayLevel[0]}}]}}, TableSpacing -> {0.8, 0.8}]}, 
             TableHeadings -> {{
                Row[{
                  Subscript[$CellContext`F, 3], 
                  Subscript[$CellContext`G, 1]}]}, None}, 
             TableSpacing -> {3, 1}], 
            TableForm[{
              TableForm[{{
                 Graph[{1, 2, 3}, {
                   UndirectedEdge[1, 2], 
                   UndirectedEdge[1, 3], 
                   UndirectedEdge[2, 3]}, {EdgeStyle -> {
                    Directive[
                    RGBColor[1, 0, 0], 
                    Thickness[Large]]}, ImageSize -> 35., 
                   VertexCoordinates -> {{0, 1}, {
                    Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
                   VertexLabels -> {
                    2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
                    Placed[3, Center]}, VertexLabelStyle -> {
                    Directive[
                    GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, 
                   VertexStyle -> {
                    GrayLevel[0]}}]}}, TableSpacing -> {0.8, 0.8}]}, 
             TableHeadings -> {{
                Row[{
                  Subscript[$CellContext`F, 4], 
                  Subscript[$CellContext`G, 1]}]}, None}, 
             TableSpacing -> {3, 1}]}, TableSpacing -> {4, 1}]}, Frame -> 
         True, FrameStyle -> Directive[
           GrayLevel[1], 
           Thickness[Large]]], $CellContext`UnlabelledSimpleGraphs[
         PatternTest[
          Pattern[$CellContext`n, 
           Blank[Integer]], NonNegative], 
         Pattern[$CellContext`scale, 
          Blank[]]] := 
       Module[{$CellContext`v, $CellContext`edges}, $CellContext`v = 
          Range[$CellContext`n]; $CellContext`edges = MapApply[UndirectedEdge, 
            Subsets[$CellContext`v, {2}]]; Apply[Join, 
           Table[
            DeleteDuplicatesBy[
             Map[Graph[$CellContext`v, #, VertexCoordinates -> Table[{
                  Sin[2 $CellContext`i (Pi/$CellContext`n)], 
                  Cos[2 $CellContext`i (Pi/$CellContext`n)]}, {$CellContext`i,
                   0, $CellContext`n - 1}], EdgeStyle -> 
               Directive[Red, Thick], VertexLabels -> None, VertexLabelStyle -> 
               Directive[White, Bold, 8], VertexStyle -> Black, VertexSize -> 
               0.35, ImageSize -> 10 $CellContext`scale]& , 
              Subsets[$CellContext`edges, {$CellContext`m}]], 
             CanonicalGraph], {$CellContext`m, 0, 
             Binomial[$CellContext`n, 2]}]]], $CellContext`genera = {{{
           Graph[{1, 2, 3}, {}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {
              2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
               Placed[3, Center]}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}]}}, {{
           Graph[{1, 2, 3}, {
             UndirectedEdge[1, 2]}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {
              2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
               Placed[3, Center]}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}], 
           Graph[{1, 2, 3}, {
             UndirectedEdge[1, 3]}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {
              2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
               Placed[3, Center]}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}], 
           Graph[{1, 2, 3}, {
             UndirectedEdge[2, 3]}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {
              2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
               Placed[3, Center]}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}]}}, {{
           Graph[{1, 2, 3}, {
             UndirectedEdge[1, 2], 
             UndirectedEdge[1, 3]}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {
              2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
               Placed[3, Center]}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}], 
           Graph[{1, 2, 3}, {
             UndirectedEdge[1, 2], 
             UndirectedEdge[2, 3]}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {
              2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
               Placed[3, Center]}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}], 
           Graph[{1, 2, 3}, {
             UndirectedEdge[1, 3], 
             UndirectedEdge[2, 3]}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {
              2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
               Placed[3, Center]}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}]}}, {{
           Graph[{1, 2, 3}, {
             UndirectedEdge[1, 2], 
             UndirectedEdge[1, 3], 
             UndirectedEdge[2, 3]}, {EdgeStyle -> {
               Directive[
                RGBColor[1, 0, 0], 
                Thickness[Large]]}, ImageSize -> 35., 
             VertexCoordinates -> {{0, 1}, {
               Sqrt[3]/2, (-1)/2}, {((-1)/2) Sqrt[3], (-1)/2}}, 
             VertexLabels -> {
              2 -> Placed[2, Center], 1 -> Placed[1, Center], 3 -> 
               Placed[3, Center]}, VertexLabelStyle -> {
               Directive[
                GrayLevel[1], Bold, 8]}, VertexSize -> {0.35}, VertexStyle -> {
               GrayLevel[0]}}]}}}, $CellContext`th = {{
          Row[{
            Subscript[$CellContext`F, 1], 
            Subscript[$CellContext`G, 1]}]}, {
          Row[{
            Subscript[$CellContext`F, 2], 
            Subscript[$CellContext`G, 1]}]}, {
          Row[{
            Subscript[$CellContext`F, 3], 
            Subscript[$CellContext`G, 1]}]}, {
          Row[{
            Subscript[$CellContext`F, 4], 
            Subscript[$CellContext`G, 1]}]}}}; Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.9662148837314625`*^9, 3.9662148866517563`*^9}, {
   3.9662174985293884`*^9, 3.9662175087252903`*^9}, 3.970269946352972*^9, 
   3.9702699863482647`*^9, 3.9706776490372925`*^9, 3.970678330002037*^9, {
   3.970678516885681*^9, 3.9706785452885933`*^9}, {3.9706785832547874`*^9, 
   3.970678593613865*^9}, 3.970679617850363*^9, 3.9706798455041733`*^9, 
   3.970679944100893*^9, 3.970700477252672*^9, 3.9707008028318195`*^9, {
   3.9707009080380154`*^9, 3.970700949755062*^9}, 3.9707012571453896`*^9, {
   3.970701311321499*^9, 3.9707013368363037`*^9}, 3.970702053241518*^9, {
   3.9707020869047356`*^9, 3.970702122621622*^9}, 3.970702184433464*^9, {
   3.9707065085786686`*^9, 3.9707065222720127`*^9}},
 CellLabel->"Out[61]=",ExpressionUUID->"da1a1c3a-408d-fb42-805c-986aa96c695e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "Save", " ", "the", " ", "output", " ", "as", " ", "a", " ", "PDF", " ", 
    "file"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "SetDirectory", "[", "\"\<C:\\\\... your directory path ...\>\"", "]"}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{"Export", "[", 
    RowBox[{"\"\<your file name.pdf\>\"", ",", "image"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.97068009273118*^9, 3.9706801557351036`*^9}, {
  3.970681059544178*^9, 3.9706810836989117`*^9}, {3.970706540271862*^9, 
  3.9707065574058075`*^9}},ExpressionUUID->"f0e56952-09de-0b4c-8e7d-\
2562ee8a2a61"]
},
WindowSize->{646.5, 630},
WindowMargins->{{Automatic, 48.75}, {Automatic, 51}},
Magnification:>0.75 Inherited,
FrontEndVersion->"14.3 for Microsoft Windows (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"5edf7e19-5702-0c41-a08e-4694f1556f3c"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[576, 22, 17252, 359, 677, "Input",ExpressionUUID->"8c4e20b7-8d83-794e-9530-d915d80c55fb"],
Cell[17831, 383, 32438, 684, 462, "Output",ExpressionUUID->"da1a1c3a-408d-fb42-805c-986aa96c695e"]
}, Open  ]],
Cell[50284, 1070, 656, 16, 49, "Input",ExpressionUUID->"f0e56952-09de-0b4c-8e7d-2562ee8a2a61"]
}
]
*)

